//=============================================================================
// RPGツクールMZ - MemoryMode.js
//=============================================================================

/*:ja
 * @target MZ
 * @plugindesc 回想イベントに必要なプラグインコマンドを定義します。
 * @author emoriiin979
 *
 * @help MemoryMode.js
 *
 * このプラグインは、回想イベントに必要なプラグインコマンドを定義します。
 *
 * プラグインコマンド:
 *   能力値保存
 *     ・アクターの現時点の能力値を全て保存しておきます。
 *
 *   能力値戻し
 *     ・回想バトル前等に保存した能力値に戻します。
 *       能力値を保存していなかった場合は何もしません。
 *
 * @command save
 * @text 能力値保存
 * @desc 回想バトル前のアクター能力値を保存します
 *
 * @arg variableId
 * @text 変数ID
 * @desc 能力値を格納する変数を指定します
 * @type variable
 *
 * @command restore
 * @text 能力値戻し
 * @desc 回想バトル前に保存した能力値に戻します
 *
 * @arg variableId
 * @text 変数ID
 * @desc 能力値を格納していた変数を指定します
 * @type variable
 */

(() => {
    "use strict";

    const pluginName = "MemoryMode";

    //=========================================================================
    // プラグインコマンド
    //=========================================================================

    // 能力値保存
    PluginManager.registerCommand(pluginName, "save", args => {
        $gameVariables.setValue(args["variableId"], {
            party: JsonEx.makeDeepCopy($gameParty),
            actors: JsonEx.makeDeepCopy($gameActors),
            switches: JsonEx.makeDeepCopy($gameSwitches),
        });
    });

    // 能力値戻し
    PluginManager.registerCommand(pluginName, "restore", args => {
        const obj = $gameVariables.value(args["variableId"]);
        if (obj) {
            $gameParty = obj.party;
            $gameActors = obj.actors;
            $gameSwitches = obj.switches;
            $gamePlayer.refresh();
        }
    });
})();
